/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.net;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.gearman.exceptions.NoServersAvailableException;
import org.gearman.net.Connection;
import org.gearman.net.ConnectionChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPool {
    private final Logger LOG = LoggerFactory.getLogger(ConnectionPool.class);
    private final List<Connection> goodConnectionList;
    private final List<Connection> badConnectionList;
    private final AtomicInteger connectionIndex;
    private final Object connectionLock = new Object();

    public ConnectionPool() {
        this.goodConnectionList = new ArrayList<Connection>();
        this.badConnectionList = new ArrayList<Connection>();
        this.connectionIndex = new AtomicInteger(0);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        ConnectionChecker checkDeadServers = new ConnectionChecker(this);
        executor.scheduleAtFixedRate(checkDeadServers, 0L, 30L, TimeUnit.SECONDS);
    }

    public void addConnection(Connection connection) {
        this.goodConnectionList.add(connection);
    }

    public boolean addHostPort(String hostName, int port) {
        this.goodConnectionList.add(new Connection(hostName, port));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDeadConnections() {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.badConnectionList.size() != 0) {
                Iterator<Connection> it = this.badConnectionList.iterator();
                while (it.hasNext()) {
                    Connection c = it.next();
                    if (!c.isHealthy()) continue;
                    this.LOG.info("Connection " + c.toString() + " is good again!");
                    this.goodConnectionList.add(c);
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws NoServersAvailableException {
        if (this.goodConnectionList.size() == 0) {
            this.checkDeadConnections();
        }
        Object object = this.connectionLock;
        synchronized (object) {
            Connection connection = null;
            while (this.goodConnectionList.size() > 0) {
                if (this.connectionIndex.get() >= this.goodConnectionList.size()) {
                    this.connectionIndex.set(0);
                }
                if ((connection = this.goodConnectionList.get(this.connectionIndex.getAndIncrement())).isHealthy()) {
                    return connection;
                }
                this.LOG.warn("Connection to " + connection.toString() + " is unhealthy, marking as bad.");
                this.badConnectionList.add(connection);
                this.goodConnectionList.remove(connection);
            }
        }
        throw new NoServersAvailableException();
    }

    public void cleanup() {
        for (Connection c : this.goodConnectionList) {
            try {
                c.close();
            }
            catch (IOException ioe) {
                this.LOG.warn("Unable to close connection: " + ioe.toString());
            }
        }
    }

    public List<Connection> getGoodConnectionList() {
        return this.goodConnectionList;
    }
}

