/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.common.packets.response;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.gearman.common.packets.response.ResponsePacket;
import org.gearman.common.packets.response.WorkResponse;
import org.gearman.constants.PacketType;

public class WorkExceptionResponse
extends ResponsePacket
implements WorkResponse {
    public AtomicReference<String> jobHandle;
    public byte[] exception;

    public WorkExceptionResponse(String jobhandle, byte[] exception) {
        this.jobHandle = new AtomicReference<String>(jobhandle);
        this.exception = (byte[])exception.clone();
        this.type = PacketType.WORK_EXCEPTION;
    }

    public WorkExceptionResponse(byte[] pktdata) {
        super(pktdata);
        this.jobHandle = new AtomicReference();
        int pOff = 0;
        pOff = this.parseString(pOff, this.jobHandle);
        this.exception = Arrays.copyOfRange(this.rawdata, pOff, this.rawdata.length);
    }

    @Override
    public byte[] toByteArray() {
        byte[] metadata = this.stringsToTerminatedByteArray(this.jobHandle.get(), new String[0]);
        return this.concatByteArrays(this.getHeader(), metadata, this.exception);
    }

    @Override
    public int getPayloadSize() {
        return this.jobHandle.get().length() + 1 + this.exception.length;
    }

    @Override
    public String getJobHandle() {
        return this.jobHandle.get();
    }

    public byte[] getException() {
        return this.exception;
    }
}

