/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.common.packets.response;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.gearman.common.packets.response.ResponsePacket;
import org.gearman.common.packets.response.WorkResponse;
import org.gearman.constants.PacketType;

public class WorkDataResponse
extends ResponsePacket
implements WorkResponse {
    public AtomicReference<String> jobHandle;
    public byte[] data;

    public WorkDataResponse(String jobhandle, byte[] data) {
        this.jobHandle = new AtomicReference<String>(jobhandle);
        this.data = (byte[])data.clone();
        this.type = PacketType.WORK_DATA;
    }

    public WorkDataResponse(byte[] pktdata) {
        super(pktdata);
        this.jobHandle = new AtomicReference();
        int pOff = 0;
        pOff = this.parseString(pOff, this.jobHandle);
        this.data = Arrays.copyOfRange(this.rawdata, pOff, this.rawdata.length);
    }

    @Override
    public byte[] toByteArray() {
        byte[] metadata = this.stringsToTerminatedByteArray(this.jobHandle.get(), new String[0]);
        return this.concatByteArrays(this.getHeader(), metadata, this.data);
    }

    @Override
    public String getJobHandle() {
        return this.jobHandle.get();
    }

    @Override
    public int getPayloadSize() {
        return this.jobHandle.get().length() + 1 + this.data.length;
    }

    public byte[] getData() {
        return this.data;
    }
}

