/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.common.packets.response;

import java.util.concurrent.atomic.AtomicReference;
import org.gearman.common.JobStatus;
import org.gearman.common.packets.response.ResponsePacket;
import org.gearman.constants.PacketType;

public class StatusRes
extends ResponsePacket {
    private final AtomicReference<String> jobHandle;
    private final boolean statusKnown;
    private final boolean running;
    private final int numerator;
    private final int denominator;

    public StatusRes(String jobHandle, boolean running, boolean statusKnown, int numerator, int denominator) {
        this.jobHandle = new AtomicReference<String>(jobHandle);
        this.running = running;
        this.statusKnown = statusKnown;
        this.numerator = numerator;
        this.denominator = denominator;
        this.type = PacketType.STATUS_RES;
    }

    public StatusRes(byte[] pktdata) {
        super(pktdata);
        this.jobHandle = new AtomicReference();
        AtomicReference<String> numeratorStr = new AtomicReference<String>();
        AtomicReference<String> denominatorStr = new AtomicReference<String>();
        AtomicReference<String> statusStr = new AtomicReference<String>();
        AtomicReference<String> runningStr = new AtomicReference<String>();
        int pOff = 0;
        pOff = this.parseString(pOff, this.jobHandle);
        pOff = this.parseString(pOff, statusStr);
        pOff = this.parseString(pOff, runningStr);
        pOff = this.parseString(pOff, numeratorStr);
        this.parseString(pOff, denominatorStr);
        this.running = Integer.parseInt(runningStr.get()) == 1;
        this.statusKnown = Integer.parseInt(statusStr.get()) == 1;
        this.denominator = Integer.parseInt(denominatorStr.get());
        this.numerator = Integer.parseInt(numeratorStr.get());
        this.type = PacketType.STATUS_RES;
    }

    public StatusRes(JobStatus jobStatus) {
        this.running = jobStatus.isRunning();
        this.statusKnown = jobStatus.isStatusKnown();
        this.denominator = jobStatus.getDenominator();
        this.numerator = jobStatus.getNumerator();
        this.jobHandle = new AtomicReference<String>(jobStatus.getJobHandle());
        this.type = PacketType.STATUS_RES;
    }

    @Override
    public byte[] toByteArray() {
        int knownStatus = this.statusKnown ? 1 : 0;
        int runningStatus = this.running ? 1 : 0;
        byte[] metadata = this.stringsToTerminatedByteArray(false, this.jobHandle.get(), String.valueOf(knownStatus), String.valueOf(runningStatus), String.valueOf(this.numerator), String.valueOf(this.denominator));
        return this.concatByteArrays(this.getHeader(), new byte[][]{metadata});
    }

    public String getJobHandle() {
        return this.jobHandle.get();
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isStatusKnown() {
        return this.statusKnown;
    }

    public float percentComplete() {
        if (this.denominator != 0) {
            return (float)this.numerator / (float)this.denominator;
        }
        return 0.0f;
    }

    @Override
    public int getPayloadSize() {
        return this.jobHandle.get().length() + 1 + 2 + 2 + String.valueOf(this.numerator).length() + 1 + String.valueOf(this.denominator).length();
    }

    @Override
    public String toString() {
        return this.jobHandle.get() + ":" + this.statusKnown + ":" + this.running + ":" + this.numerator + ":" + this.denominator;
    }
}

