/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.common.packets.request;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.gearman.common.packets.request.RequestPacket;
import org.gearman.constants.PacketType;

public class SetClientId
extends RequestPacket {
    private AtomicReference<String> clientId;

    public SetClientId() {
        this(UUID.randomUUID().toString());
    }

    public SetClientId(String clientId) {
        this.type = PacketType.SET_CLIENT_ID;
        this.clientId = new AtomicReference<String>(clientId);
    }

    public SetClientId(byte[] pktdata) {
        super(pktdata);
        this.clientId = new AtomicReference();
        int pOff = 0;
        this.parseString(pOff, this.clientId);
    }

    public String getClientId() {
        return this.clientId.get();
    }

    @Override
    public byte[] toByteArray() {
        return this.concatByteArrays(this.getHeader(), new byte[][]{this.clientId.get().getBytes()});
    }

    @Override
    public int getPayloadSize() {
        return this.clientId.get().length();
    }
}

