/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.common.packets.request;

import java.util.Arrays;
import org.gearman.common.packets.request.RequestPacket;
import org.gearman.constants.GearmanConstants;
import org.gearman.constants.PacketType;

public class EchoRequest
extends RequestPacket {
    private final byte[] data;

    public EchoRequest(String data) {
        byte[] dataBytes = data.getBytes(GearmanConstants.CHARSET);
        this.data = (byte[])dataBytes.clone();
        this.type = PacketType.ECHO_REQ;
    }

    public EchoRequest(byte[] pktdata) {
        super(pktdata);
        int pOff = 0;
        this.data = Arrays.copyOfRange(this.rawdata, pOff, this.rawdata.length);
        this.type = PacketType.ECHO_REQ;
    }

    @Override
    public byte[] toByteArray() {
        return this.concatByteArrays(this.getHeader(), new byte[][]{this.data});
    }

    @Override
    public int getPayloadSize() {
        return this.data.length;
    }

    public byte[] getData() {
        return this.data;
    }
}

