/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.common.packets;

import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.gearman.constants.PacketType;

public abstract class Packet {
    protected PacketType type;
    protected int size;
    protected byte[] rawdata;
    private byte[] header;

    public Packet() {
        this.header = null;
    }

    public Packet(byte[] fromdata) {
        byte[] typebytes = Arrays.copyOfRange(fromdata, 4, 8);
        byte[] sizebytes = Arrays.copyOfRange(fromdata, 8, 12);
        this.type = PacketType.fromPacketMagicNumber(Ints.fromByteArray((byte[])typebytes));
        this.size = Ints.fromByteArray((byte[])sizebytes);
        this.rawdata = Arrays.copyOfRange(fromdata, 12, fromdata.length);
    }

    public byte[] getHeader() {
        if (this.header == null) {
            byte[] typebytes = Ints.toByteArray((int)this.type.getIndex());
            byte[] sizebytes = Ints.toByteArray((int)this.getPayloadSize());
            this.header = this.concatByteArrays(this.getMagic(), typebytes, sizebytes);
        }
        return (byte[])this.header.clone();
    }

    public PacketType getType() {
        return this.type;
    }

    public abstract byte[] toByteArray();

    public abstract int getPayloadSize();

    public abstract byte[] getMagic();

    public int getSize() {
        return 12 + this.getPayloadSize();
    }

    public String toString() {
        return this.type.toString();
    }

    protected int parseString(int offset, AtomicReference<String> storage) {
        int pStart;
        int pOff;
        for (pOff = pStart = offset; pOff < this.rawdata.length && this.rawdata[pOff] != 0; ++pOff) {
        }
        storage.set(new String(Arrays.copyOfRange(this.rawdata, pStart, pOff)));
        return pOff + 1;
    }

    protected byte[] stringsToTerminatedByteArray(String first, String ... rest) {
        return this.stringsToTerminatedByteArray(true, first, rest);
    }

    protected byte[] stringsToTerminatedByteArray(boolean terminateFinal, String first, String ... rest) {
        StringBuffer fullString = new StringBuffer();
        fullString.append(first);
        fullString.append('\u0000');
        for (int i = 0; i < rest.length; ++i) {
            String member = rest[i];
            fullString.append(member);
            if (!terminateFinal && i >= rest.length - 1) continue;
            fullString.append('\u0000');
        }
        return fullString.toString().getBytes();
    }

    protected byte[] concatByteArrays(byte[] first, byte[] ... rest) {
        int totalLength = first.length;
        for (byte[] array : rest) {
            totalLength += array.length;
        }
        byte[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (byte[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }
}

