/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.util;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.gearman.constants.GearmanConstants;

public final class ByteArray {
    private final byte[] bytes;
    private int offset;

    public ByteArray() {
        this.bytes = null;
        this.offset = 0;
    }

    public ByteArray(byte[] bytes) {
        this.bytes = bytes;
        this.offset = bytes.length;
    }

    public ByteArray(String value) {
        this.bytes = value.getBytes(GearmanConstants.CHARSET);
        this.offset = this.bytes.length;
    }

    public ByteArray(int length) {
        this.bytes = new byte[length];
        this.offset = 0;
    }

    public final int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public final byte[] getBytes() {
        return (byte[])this.bytes.clone();
    }

    public final byte get(int index) {
        return this.bytes[index];
    }

    public final String toString(Charset charset) {
        return new String(this.bytes, charset);
    }

    public final boolean isEmpty() {
        return this.bytes.length == 0;
    }

    public final int length() {
        return this.bytes.length;
    }

    public final String toString() {
        return new String(this.bytes);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof ByteArray) {
            return this.equals((ByteArray)obj);
        }
        if (obj instanceof byte[]) {
            return this.equals((byte[])obj);
        }
        return false;
    }

    public final boolean equals(ByteArray array) {
        return this == array || this.equals(array.bytes);
    }

    public final boolean equals(byte[] array) {
        return Arrays.equals(this.bytes, array);
    }

    public void push(byte b) {
        if (this.offset >= this.bytes.length) {
            throw new ArrayIndexOutOfBoundsException("Underlying byte array is full.");
        }
        this.bytes[this.offset++] = b;
    }
}

