/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.net;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.Date;
import org.gearman.common.packets.Packet;
import org.gearman.common.packets.PacketFactory;
import org.gearman.common.packets.request.EchoRequest;
import org.gearman.common.packets.response.EchoResponse;
import org.gearman.constants.GearmanConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    protected Socket socket;
    protected String hostname;
    protected int port;
    private Logger LOG = LoggerFactory.getLogger(Connection.class);
    private Long lastTimeSeenAlive;
    private boolean isGood;
    private long HEALTHCHECK_MSEC = 1800000L;

    public Connection() {
    }

    public Connection(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    public Connection(Socket socket) {
        this.socket = socket;
    }

    public void sendPacket(Packet p) throws IOException {
        try {
            this.initializeConnection();
            this.socket.getOutputStream().write(p.toByteArray());
        }
        catch (IOException ioe) {
            this.isGood = false;
            throw ioe;
        }
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public String toString() {
        return String.format("%s:%d", this.hostname, this.port);
    }

    public boolean isHealthy() {
        try {
            this.initializeConnection();
        }
        catch (IOException ioe) {
            return false;
        }
        if (this.isGood && !this.shouldCheckHealth()) {
            return true;
        }
        try {
            byte[] matchData;
            byte[] data;
            this.sendPacket(new EchoRequest("OK"));
            EchoResponse response = (EchoResponse)this.getNextPacket();
            if (response != null && Arrays.equals(data = response.getData(), matchData = "OK".getBytes(GearmanConstants.CHARSET))) {
                this.updateLastTimeSeenAlive();
                return true;
            }
        }
        catch (IOException ioe) {
            this.LOG.error("Client unable to write to socket: " + ioe.toString());
            try {
                this.socket.close();
            }
            catch (IOException closeException) {
                this.LOG.error("Unable to close dead socket: " + closeException.toString());
            }
        }
        return false;
    }

    public Packet getNextPacket() throws IOException {
        try {
            this.initializeConnection();
        }
        catch (IOException ioe) {
            this.isGood = false;
            return null;
        }
        int messagesize = -1;
        byte[] header = new byte[12];
        try {
            InputStream is = this.socket.getInputStream();
            int numbytes = is.read(header, 0, 12);
            if (numbytes == 12) {
                byte[] sizebytes = Arrays.copyOfRange(header, 8, 12);
                messagesize = Ints.fromByteArray((byte[])sizebytes);
                byte[] packetBytes = messagesize > 0 ? Arrays.copyOf(header, 12 + messagesize) : header;
                is.read(packetBytes, 12, messagesize);
                return PacketFactory.packetFromBytes(packetBytes);
            }
            if (numbytes == -1) {
                throw new IOException("Network socket EOF.");
            }
        }
        catch (IOException ioe) {
            this.LOG.error("Exception reading data: ", (Object)ioe.toString());
            throw ioe;
        }
        return null;
    }

    public Long getLastTimeSeenAlive() {
        return this.lastTimeSeenAlive;
    }

    public void setLastTimeSeenAlive(Long lastTimeSeenAlive) {
        this.lastTimeSeenAlive = lastTimeSeenAlive;
    }

    private boolean shouldCheckHealth() {
        Long now = new Date().getTime();
        return now - this.getLastTimeSeenAlive() > this.HEALTHCHECK_MSEC;
    }

    private void initializeConnection() throws IOException {
        if (this.socket == null || this.socket.isClosed()) {
            this.socket = new Socket(this.hostname, this.port);
            this.isGood = true;
        }
    }

    public void updateLastTimeSeenAlive() {
        this.lastTimeSeenAlive = new Date().getTime();
    }

    public void setHealthCheckInterval(long interval) {
        this.HEALTHCHECK_MSEC = interval;
    }
}

