/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.common.packets.response;

import java.util.concurrent.atomic.AtomicReference;
import org.gearman.common.JobStatus;
import org.gearman.common.packets.response.ResponsePacket;
import org.gearman.constants.PacketType;

public class WorkStatus
extends ResponsePacket {
    private AtomicReference<String> jobHandle;
    private int completenumerator;
    private int completedenominator;

    public WorkStatus() {
    }

    public WorkStatus(String jobhandle, int numerator, int denominator) {
        this.jobHandle = new AtomicReference<String>(jobhandle);
        this.completenumerator = numerator;
        this.completedenominator = denominator;
        this.type = PacketType.WORK_STATUS;
    }

    public WorkStatus(JobStatus jobStatus) {
        this.jobHandle = new AtomicReference<String>(jobStatus.getJobHandle());
        this.completedenominator = jobStatus.getDenominator();
        this.completenumerator = jobStatus.getNumerator();
        this.type = PacketType.WORK_STATUS;
    }

    public WorkStatus(byte[] pktdata) {
        super(pktdata);
        this.jobHandle = new AtomicReference();
        AtomicReference<String> numerator = new AtomicReference<String>();
        AtomicReference<String> denominator = new AtomicReference<String>();
        int pOff = 0;
        pOff = this.parseString(pOff, this.jobHandle);
        pOff = this.parseString(pOff, numerator);
        pOff = this.parseString(pOff, denominator);
        try {
            this.completedenominator = Integer.valueOf(denominator.get());
        }
        catch (NumberFormatException nfe) {
            this.completedenominator = -1;
        }
        try {
            this.completenumerator = Integer.valueOf(numerator.get());
        }
        catch (NumberFormatException nfe) {
            this.completenumerator = -1;
        }
    }

    @Override
    public byte[] toByteArray() {
        byte[] metadata = this.stringsToTerminatedByteArray(false, this.jobHandle.get(), String.valueOf(this.completenumerator), String.valueOf(this.completedenominator));
        return this.concatByteArrays(this.getHeader(), new byte[][]{metadata});
    }

    @Override
    public int getPayloadSize() {
        return this.jobHandle.get().length() + 1 + String.valueOf(this.completenumerator).length() + 1 + String.valueOf(this.completedenominator).length();
    }

    public String getJobHandle() {
        return this.jobHandle.get();
    }

    public int getCompletenumerator() {
        return this.completenumerator;
    }

    public int getCompletedenominator() {
        return this.completedenominator;
    }
}

