/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.common.packets.response;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.gearman.common.packets.response.ResponsePacket;
import org.gearman.constants.PacketType;

public class JobAssign
extends ResponsePacket {
    private AtomicReference<String> jobHandle;
    private AtomicReference<String> functionName;
    private byte[] data;

    public JobAssign(byte[] pktdata) {
        super(pktdata);
        this.jobHandle = new AtomicReference();
        this.functionName = new AtomicReference();
        int pOff = this.parseString(0, this.jobHandle);
        pOff = this.parseString(pOff, this.functionName);
        this.data = Arrays.copyOfRange(this.rawdata, pOff, this.rawdata.length);
        this.type = PacketType.JOB_ASSIGN;
    }

    public JobAssign(String jobhandle, String functionName, byte[] data) {
        this.jobHandle = new AtomicReference<String>(jobhandle);
        this.functionName = new AtomicReference<String>(functionName);
        this.data = (byte[])data.clone();
        this.type = PacketType.JOB_ASSIGN;
    }

    public String getJobHandle() {
        return this.jobHandle.get();
    }

    @Override
    public byte[] toByteArray() {
        byte[] metadata = this.stringsToTerminatedByteArray(this.jobHandle.get(), this.functionName.get());
        return this.concatByteArrays(this.getHeader(), metadata, this.data);
    }

    @Override
    public int getPayloadSize() {
        return this.jobHandle.get().length() + 1 + this.functionName.get().length() + 1 + this.data.length;
    }

    public String getFunctionName() {
        return this.functionName.get();
    }

    public byte[] getData() {
        return this.data;
    }
}

