/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.common.packets.response;

import java.util.Arrays;
import org.gearman.common.packets.request.EchoRequest;
import org.gearman.common.packets.response.ResponsePacket;
import org.gearman.constants.PacketType;

public class EchoResponse
extends ResponsePacket {
    private final byte[] data;

    public EchoResponse(EchoRequest echoRequest) {
        this.type = PacketType.ECHO_RES;
        this.data = (byte[])echoRequest.getData().clone();
    }

    public EchoResponse(byte[] pktdata) {
        super(pktdata);
        int pOff = 0;
        this.data = Arrays.copyOfRange(this.rawdata, pOff, this.rawdata.length);
        this.type = PacketType.ECHO_RES;
    }

    @Override
    public byte[] toByteArray() {
        byte[] result = this.concatByteArrays(this.getHeader(), new byte[][]{this.data});
        return result;
    }

    @Override
    public int getPayloadSize() {
        return this.data.length;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "ECHO_RESPONSE";
    }
}

