/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.common.packets.request;

import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import org.gearman.common.packets.request.RequestPacket;
import org.gearman.constants.JobPriority;
import org.gearman.constants.PacketType;

public class SubmitJob
extends RequestPacket {
    private final AtomicReference<String> taskName;
    private final AtomicReference<String> uniqueId;
    private final AtomicReference<String> epochString;
    private final byte[] data;
    private final boolean background;
    private final int size;

    public SubmitJob(byte[] pktdata) {
        super(pktdata);
        this.taskName = new AtomicReference();
        this.uniqueId = new AtomicReference();
        this.epochString = new AtomicReference();
        int pOff = 0;
        pOff = this.parseString(pOff, this.taskName);
        pOff = this.parseString(pOff, this.uniqueId);
        if (this.type == PacketType.SUBMIT_JOB_EPOCH) {
            pOff = this.parseString(pOff, this.epochString);
        }
        this.background = this.type == PacketType.SUBMIT_JOB_HIGH_BG || this.type == PacketType.SUBMIT_JOB_LOW_BG || this.type == PacketType.SUBMIT_JOB_BG || this.type == PacketType.SUBMIT_JOB_EPOCH;
        this.data = Arrays.copyOfRange(this.rawdata, pOff, this.rawdata.length);
        this.size = this.rawdata.length;
    }

    public SubmitJob(String function, String unique_id, byte[] data, boolean background) {
        this(function, unique_id, data, background, JobPriority.NORMAL);
    }

    public SubmitJob(String function, String unique_id, byte[] data, boolean background, JobPriority priority) {
        this.taskName = new AtomicReference<String>(function);
        this.uniqueId = new AtomicReference<String>(unique_id);
        this.epochString = new AtomicReference();
        this.background = background;
        this.data = (byte[])data.clone();
        switch (priority) {
            case HIGH: {
                this.type = background ? PacketType.SUBMIT_JOB_HIGH_BG : PacketType.SUBMIT_JOB_HIGH;
                break;
            }
            case NORMAL: {
                this.type = background ? PacketType.SUBMIT_JOB_BG : PacketType.SUBMIT_JOB;
                break;
            }
            case LOW: {
                this.type = background ? PacketType.SUBMIT_JOB_LOW_BG : PacketType.SUBMIT_JOB_LOW;
                break;
            }
        }
        this.size = function.length() + 1 + unique_id.length() + 1 + data.length;
    }

    public Date getWhen() {
        return new Date(Long.parseLong(this.epochString.get()));
    }

    public JobPriority getPriority() {
        switch (this.type) {
            case SUBMIT_JOB: 
            case SUBMIT_JOB_BG: 
            case SUBMIT_JOB_EPOCH: 
            case SUBMIT_JOB_SCHED: {
                return JobPriority.NORMAL;
            }
            case SUBMIT_JOB_HIGH: 
            case SUBMIT_JOB_HIGH_BG: {
                return JobPriority.HIGH;
            }
            case SUBMIT_JOB_LOW: 
            case SUBMIT_JOB_LOW_BG: {
                return JobPriority.LOW;
            }
        }
        return null;
    }

    public String getFunctionName() {
        return this.taskName.get();
    }

    public String getUniqueId() {
        return this.uniqueId.get();
    }

    public boolean isBackground() {
        return this.background;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getEpoch() {
        return Long.parseLong(this.epochString.get());
    }

    @Override
    public byte[] toByteArray() {
        byte[] metadata = this.type == PacketType.SUBMIT_JOB_EPOCH ? this.stringsToTerminatedByteArray(this.taskName.get(), this.uniqueId.get(), this.epochString.get()) : this.stringsToTerminatedByteArray(this.taskName.get(), this.uniqueId.get());
        byte[] result = this.concatByteArrays(this.getHeader(), metadata, this.data);
        return result;
    }

    @Override
    public int getPayloadSize() {
        return this.size;
    }

    @Override
    public String toString() {
        return this.type.toString();
    }
}

