/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.common.packets;

import com.google.common.primitives.Ints;
import java.util.Arrays;
import org.gearman.common.packets.Packet;
import org.gearman.common.packets.request.CanDo;
import org.gearman.common.packets.request.CantDo;
import org.gearman.common.packets.request.EchoRequest;
import org.gearman.common.packets.request.GetStatus;
import org.gearman.common.packets.request.GrabJob;
import org.gearman.common.packets.request.PreSleep;
import org.gearman.common.packets.request.SetClientId;
import org.gearman.common.packets.request.SubmitJob;
import org.gearman.common.packets.response.EchoResponse;
import org.gearman.common.packets.response.JobAssign;
import org.gearman.common.packets.response.JobAssignUniq;
import org.gearman.common.packets.response.JobCreated;
import org.gearman.common.packets.response.NoJob;
import org.gearman.common.packets.response.NoOp;
import org.gearman.common.packets.response.StatusRes;
import org.gearman.common.packets.response.WorkCompleteResponse;
import org.gearman.common.packets.response.WorkDataResponse;
import org.gearman.common.packets.response.WorkExceptionResponse;
import org.gearman.common.packets.response.WorkFailResponse;
import org.gearman.common.packets.response.WorkStatus;
import org.gearman.common.packets.response.WorkWarningResponse;
import org.gearman.constants.PacketType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PacketFactory.class);

    public static Packet packetFromBytes(byte[] packetBytes) {
        byte[] sizebytes = Arrays.copyOfRange(packetBytes, 8, 12);
        byte[] typebytes = Arrays.copyOfRange(packetBytes, 4, 8);
        byte[] magicbytes = Arrays.copyOfRange(packetBytes, 0, 4);
        int messagesize = Ints.fromByteArray((byte[])sizebytes);
        int messagetype = Ints.fromByteArray((byte[])typebytes);
        PacketType packetType = PacketType.fromPacketMagicNumber(messagetype);
        switch (packetType) {
            case JOB_CREATED: {
                return new JobCreated(packetBytes);
            }
            case WORK_DATA: {
                return new WorkDataResponse(packetBytes);
            }
            case WORK_WARNING: {
                return new WorkWarningResponse(packetBytes);
            }
            case WORK_STATUS: {
                return new WorkStatus(packetBytes);
            }
            case WORK_COMPLETE: {
                return new WorkCompleteResponse(packetBytes);
            }
            case WORK_FAIL: {
                return new WorkFailResponse(packetBytes);
            }
            case WORK_EXCEPTION: {
                return new WorkExceptionResponse(packetBytes);
            }
            case STATUS_RES: {
                return new StatusRes(packetBytes);
            }
            case GET_STATUS: {
                return new GetStatus(packetBytes);
            }
            case NOOP: {
                return new NoOp();
            }
            case NO_JOB: {
                return new NoJob();
            }
            case JOB_ASSIGN: {
                return new JobAssign(packetBytes);
            }
            case JOB_ASSIGN_UNIQ: {
                return new JobAssignUniq(packetBytes);
            }
            case CANT_DO: {
                return new CantDo(packetBytes);
            }
            case CAN_DO: {
                return new CanDo(packetBytes);
            }
            case GRAB_JOB: {
                return new GrabJob(packetBytes);
            }
            case PRE_SLEEP: {
                return new PreSleep(packetBytes);
            }
            case SET_CLIENT_ID: {
                return new SetClientId(packetBytes);
            }
            case SUBMIT_JOB: 
            case SUBMIT_JOB_HIGH: 
            case SUBMIT_JOB_LOW: 
            case SUBMIT_JOB_BG: 
            case SUBMIT_JOB_HIGH_BG: 
            case SUBMIT_JOB_LOW_BG: 
            case SUBMIT_JOB_SCHED: 
            case SUBMIT_JOB_EPOCH: {
                return new SubmitJob(packetBytes);
            }
            case ECHO_REQ: {
                return new EchoRequest(packetBytes);
            }
            case ECHO_RES: {
                return new EchoResponse(packetBytes);
            }
        }
        LOG.error("Unhandled type: ", (Object)messagetype);
        return null;
    }
}

