/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Date;
import org.gearman.common.JobState;
import org.gearman.common.JobStatus;
import org.gearman.constants.JobPriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Job {
    private static Logger LOG = LoggerFactory.getLogger(Job.class);
    private JobPriority priority;
    private boolean background;
    private String functionName;
    private String uniqueID;
    private String jobHandle;
    private byte[] data;
    private int numerator;
    private int denominator;
    private long timeToRun;
    private JobState state = JobState.QUEUED;

    public Job() {
        this.background = false;
        this.functionName = null;
        this.uniqueID = null;
        this.jobHandle = null;
        this.data = null;
        this.priority = JobPriority.NORMAL;
        this.timeToRun = -1L;
    }

    public Job(String functionName, String uniqueID, byte[] data, JobPriority priority, boolean isBackground) {
        this(functionName, uniqueID, data, priority, isBackground, -1L);
    }

    public Job(String functionName, String uniqueID, byte[] data, JobPriority priority, boolean isBackground, long timeToRun) {
        this.functionName = functionName;
        this.uniqueID = uniqueID;
        this.data = (byte[])data.clone();
        this.priority = priority;
        this.timeToRun = timeToRun;
        this.background = isBackground;
    }

    public Job(String functionName, String uniqueID, byte[] data, byte[] jobHandle, JobPriority priority, boolean isBackground, long timeToRun) {
        this.functionName = functionName;
        this.uniqueID = uniqueID;
        this.data = (byte[])data.clone();
        this.priority = priority;
        this.timeToRun = timeToRun;
        this.background = isBackground;
        this.jobHandle = new String(jobHandle);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getJobHandle() {
        return this.jobHandle;
    }

    public void setJobHandle(String jobHandle) {
        this.jobHandle = jobHandle;
    }

    public JobPriority getPriority() {
        return this.priority;
    }

    public JobState getState() {
        return this.state;
    }

    public void setState(JobState state) {
        this.state = state;
    }

    public long getTimeToRun() {
        return this.timeToRun;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public void setUniqueID(String uniqueID) {
        this.uniqueID = uniqueID;
    }

    public boolean isBackground() {
        return this.background;
    }

    public void setStatus(int numerator, int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public final void complete() {
        this.state = JobState.COMPLETE;
    }

    @JsonIgnore
    public String toString() {
        return this.getJobHandle();
    }

    @JsonIgnore
    public JobStatus getStatus() {
        return new JobStatus(this.numerator, this.denominator, this.state, this.jobHandle);
    }

    @JsonIgnore
    public boolean isReady() {
        return this.timeToRun < new Date().getTime() / 1000L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job)o;
        if (this.background != job.background) {
            return false;
        }
        if (!Arrays.equals(this.data, job.data)) {
            return false;
        }
        if (this.functionName != null ? !this.functionName.equals(job.functionName) : job.functionName != null) {
            return false;
        }
        if (this.priority != job.priority) {
            return false;
        }
        return !(this.uniqueID != null ? !this.uniqueID.equals(job.uniqueID) : job.uniqueID != null);
    }

    public int hashCode() {
        int result = this.functionName != null ? this.functionName.hashCode() : 0;
        result = 31 * result + (this.uniqueID != null ? this.uniqueID.hashCode() : 0);
        return result;
    }
}

