/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.client;

import java.io.IOException;
import java.util.UUID;
import org.gearman.common.packets.Packet;
import org.gearman.common.packets.request.GetStatus;
import org.gearman.common.packets.request.SubmitJob;
import org.gearman.common.packets.response.JobCreated;
import org.gearman.common.packets.response.StatusRes;
import org.gearman.common.packets.response.WorkCompleteResponse;
import org.gearman.constants.JobPriority;
import org.gearman.constants.PacketType;
import org.gearman.exceptions.NoServersAvailableException;
import org.gearman.net.Connection;
import org.gearman.net.ConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GearmanClient {
    private final Logger LOG = LoggerFactory.getLogger(GearmanClient.class);
    private final ConnectionPool connectionPool = new ConnectionPool();

    public GearmanClient() {
    }

    public GearmanClient(String host, int port) throws IOException {
        this();
        this.connectionPool.addHostPort(host, port);
    }

    public GearmanClient(String host) throws IOException {
        this(host, 4730);
    }

    public GearmanClient(Connection conn) {
        this();
        this.connectionPool.addConnection(conn);
    }

    public void addConnection(Connection conn) {
        this.connectionPool.addConnection(conn);
    }

    public void addHostToList(String host, int port) throws IOException {
        this.connectionPool.addHostPort(host, port);
    }

    public void addHostToList(String host) throws IOException {
        this.addHostToList(host, 4730);
    }

    public void close() {
        this.connectionPool.cleanup();
    }

    private ServerResponse sendJobPacket(SubmitJob jobPacket) throws NoServersAvailableException {
        Connection connection;
        while ((connection = this.connectionPool.getConnection()) != null) {
            try {
                connection.sendPacket((Packet)jobPacket);
                this.LOG.debug("Sent job request to " + connection.toString());
                Packet result = connection.getNextPacket();
                if (result == null || result.getType() != PacketType.JOB_CREATED) continue;
                this.LOG.debug("Created job " + ((JobCreated)result).getJobHandle());
                return new ServerResponse(connection, result);
            }
            catch (IOException ioe) {
                this.LOG.error("Connection to " + connection.toString() + " flaky, marking as bad.");
            }
        }
        throw new NoServersAvailableException();
    }

    public byte[] submitJob(String callback, byte[] data) {
        Packet result = null;
        try {
            String jobid = UUID.randomUUID().toString();
            ServerResponse response = this.sendJobPacket(new SubmitJob(callback, jobid, data, false));
            if (response != null) {
                while ((result = response.getConnection().getNextPacket()).getType() != PacketType.WORK_COMPLETE) {
                }
                WorkCompleteResponse wc = (WorkCompleteResponse)result;
                this.LOG.debug("Completed job " + wc.getJobHandle());
                return wc.data;
            }
            this.LOG.warn("Unable to submit job to job severs...");
        }
        catch (IOException e) {
            this.LOG.error("Error submitting job: ", (Throwable)e);
        }
        catch (NoServersAvailableException nsae) {
            this.LOG.error("No servers available to submit the job.");
        }
        return null;
    }

    public String submitJobInBackground(String callback, byte[] data, JobPriority priority) throws NoServersAvailableException {
        String jobid = UUID.randomUUID().toString();
        try {
            ServerResponse response = this.sendJobPacket(new SubmitJob(callback, jobid, data, true, priority));
            if (response != null) {
                this.LOG.debug("Sent background job request to " + response.getConnection());
                if (response.getPacket().getType() == PacketType.JOB_CREATED) {
                    String jobHandle = ((JobCreated)response.getPacket()).getJobHandle();
                    this.LOG.debug("Created background job %s, with priority %s\n", (Object)jobHandle, (Object)priority.toString());
                    return jobHandle;
                }
            }
        }
        catch (NoServersAvailableException nsae) {
            this.LOG.warn("No servers available to submit the job.");
            throw nsae;
        }
        return null;
    }

    public StatusRes getStatus(String jobHandle) {
        GetStatus statusPkt = new GetStatus(jobHandle);
        for (Connection conn : this.connectionPool.getGoodConnectionList()) {
            this.LOG.debug("Checking for status on %s on %s\n", (Object)jobHandle, (Object)conn);
            try {
                StatusRes statusResult;
                conn.sendPacket((Packet)statusPkt);
                Packet result = conn.getNextPacket();
                if (result.getType() != PacketType.STATUS_RES || !(statusResult = (StatusRes)result).getJobHandle().equals(jobHandle)) continue;
                return statusResult;
            }
            catch (IOException ioe) {
                this.LOG.error("Unable to send request to " + conn + ": " + ioe);
            }
        }
        return null;
    }

    class ServerResponse {
        private Connection connection;
        private Packet packet;

        public ServerResponse(Connection connection, Packet packet) {
            this.connection = connection;
            this.packet = packet;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public Packet getPacket() {
            return this.packet;
        }
    }
}

